#include <Servo.h>    
int MotorLeft1 =8;   //IN1
int MotorLeft2 = 11; //IN2
int MotorRight1 = 12;  //IN3
int MotorRight2 = 13;  //IN4
int EA = 9;    //enable out1
int EB = 10;   //enable out2

//Status of four motor
uint8_t MotorLeft1Status = LOW;
uint8_t MotorLeft2Status = LOW;
uint8_t MotorRight1Status = LOW;
uint8_t MotorRight2Status = LOW;

Servo servoX;
Servo servoY;

byte serialIn = 0;
byte commandAvailable = false;
String strReceived = "";

//the senter angle of two servo
byte servoXCenterPoint = 94;
byte servoYCenterPoint = 90 ;
//the max angle of two servo
byte servoXmax = 170;
byte servoYmax = 130;
//the min angler of two servo
byte servoXmini = 10;
byte servoYmini = 10;
//the current angle of two servo
byte servoXPoint = 0;
byte servoYPoint = 0;
//current speed of motor
byte leftspeed = 0;
byte rightspeed = 0;

byte servoStep = 4;


void setup()
{
	servoX.attach(6);//servo 1
	servoY.attach(7);//servo 2

	pinMode(MotorLeft1, OUTPUT);
	pinMode(MotorLeft2, OUTPUT);
	pinMode(MotorRight1, OUTPUT);
	pinMode(MotorRight2, OUTPUT);
	servo_test();//test servo
	Serial.begin(9600);
}


void loop()
{
	getSerialLine();
	if (commandAvailable) {
		processCommand(strReceived);
		strReceived = "";
		commandAvailable = false;
	}
}


void getSerialLine()
{
	while (serialIn != '\r')
	{
		if (!(Serial.available() > 0))
		{
			return;
		}

		serialIn = Serial.read();
		if (serialIn != '\r') {
			if (serialIn != '\n'){
				char a = char(serialIn);
				strReceived += a;
			}
		}
	}
	if (serialIn == '\r') {
		commandAvailable = true;
		serialIn = 0;
	}

}
void processCommand(String input)
{
	String command = getValue(input, ' ', 0);
	byte iscommand = true;
	int val;
	if (command == "MD_Qian")
	{
		advance();
	}
	else if (command == "MD_Hou")
	{
		back();
	}
	else if (command == "MD_Zuo")
	{
		left();
	}
	else if (command == "MD_You")
	{
		right();
	}
	else if (command == "MD_Ting")
	{
		Stop();
	}
	else if (command == "MD_SD")
	{
		val = getValue(input, ' ', 1).toInt();
		leftspeed = val;
		val = getValue(input, ' ', 2).toInt();
		rightspeed = val;
	}
	else if (command == "DJ_CS")
	{
		servo_test();
	}
	else if (command == "DJ_Shang")
	{
		servo_up();
	}
	else if (command == "DJ_Xia")
	{
		servo_down();
	}
	else if (command == "DJ_Zuo")
	{
		servo_left();
	}
	else if (command == "DJ_You")
	{
		servo_right();
	}
	else if (command == "DJ_Zhong")
	{
		servo_center();
	}
	else if (command == "DJ_CZ_JD")//VerticalRotation
	{
		val = getValue(input, ' ', 1).toInt();
	}
	else if (command == "DJ_SP_JD")//Horizontal rotation
	{
		val = getValue(input, ' ', 1).toInt();
	}
	else
	{
		iscommand = false;
	}
	if (iscommand){
		SendMessage("cmd:" + input);
		SendStatus();
	}
	
}
String getValue(String data, char separator, int index)
{
	int found = 0;
	int strIndex[] = {
		0, -1 };
	int maxIndex = data.length() - 1;

	for (int i = 0; i <= maxIndex && found <= index; i++){
		if (data.charAt(i) == separator || i == maxIndex){
			found++;
			strIndex[0] = strIndex[1] + 1;
			strIndex[1] = (i == maxIndex) ? i + 1 : i;
		}
	}

	return found>index ? data.substring(strIndex[0], strIndex[1]) : "";
}
void servo_test(void) {
	int nowcornerY = servoY.read();
	int nowcornerX = servoX.read();
	servo_Vertical(servoYmini);
	delay(500);
	servo_Vertical(servoYmax);
	delay(500);
	servo_Vertical(servoYCenterPoint);
	delay(500);
	servo_Horizontal(servoXmini);
	delay(500);
	servo_Horizontal(servoXmax);
	delay(500);
	servo_Horizontal(servoXCenterPoint);
	delay(500);
	servo_center();
}
void servo_right(void)
{
	int servotemp = servoX.read();
	servotemp -= servoStep;
	servo_Horizontal(servotemp);
}
void servo_left(void)
{
	int servotemp = servoX.read();
	servotemp += servoStep;
	servo_Horizontal(servotemp);
}
void servo_down(void)
{
	int servotemp = servoY.read();
	servotemp += servoStep;
	servo_Vertical(servotemp);
}
void servo_up(void)
{
	int servotemp = servoY.read();
	servotemp -= servoStep;
	servo_Vertical(servotemp);
}
void servo_center(void)
{
	servo_Vertical(servoYCenterPoint);
	servo_Horizontal(servoXCenterPoint);
}
void servo_Vertical(int corner)
{
	int cornerY = servoY.read();
	if (cornerY > corner) {
		for (int i = cornerY; i > corner; i = i - servoStep) {
			servoY.write(i);
			servoYPoint = i;
			delay(50);
		}
	}
	else {
		for (int i = cornerY; i < corner; i = i + servoStep) {
			servoY.write(i);
			servoYPoint = i;
			delay(50);
		}
	}
	servoY.write(corner);
	servoYPoint = corner;
}
void servo_Horizontal(int corner)
{
	int i = 0;
	byte cornerX = servoX.read();
	if (cornerX > corner) {
		for (i = cornerX; i > corner; i = i - servoStep) {
			servoX.write(i);
			servoXPoint = i;
			delay(50);
		}
	}
	else {
		for (i = cornerX; i < corner; i = i + servoStep) {
			servoX.write(i);
			servoXPoint = i;
			delay(50);
		}
	}
	servoX.write(corner);
	servoXPoint = corner;
}

void advance(void)
{
	MotorLeft1Status = LOW;
	MotorLeft2Status = HIGH;
	MotorRight1Status = LOW;
	MotorRight2Status = HIGH;
	SetEN();
}
void back(void)
{
	MotorLeft1Status = HIGH;
	MotorLeft2Status = LOW;
	MotorRight1Status = HIGH;
	MotorRight2Status = LOW;
	SetEN();
}
void right(void)
{
	MotorLeft1Status = LOW;
	MotorLeft2Status = HIGH;
	MotorRight1Status = HIGH;
	MotorRight2Status = LOW;
	SetEN();
}
void left(void)
{
	MotorLeft1Status = HIGH;
	MotorLeft2Status = LOW;
	MotorRight1Status = LOW;
	MotorRight2Status = HIGH;
	SetEN();
}
void Stop(void)
{
	leftspeed = 0;
	rightspeed = 0;
	MotorLeft1Status = LOW;
	MotorLeft2Status = LOW;
	MotorRight1Status = LOW;
	MotorRight2Status = LOW;
	SetEN();
}

void SetEN(){
	analogWrite(EA, leftspeed);
	analogWrite(EB, rightspeed);
	digitalWrite(MotorLeft1, MotorLeft1Status);
	digitalWrite(MotorLeft2, MotorLeft2Status);
	digitalWrite(MotorRight1, MotorRight1Status);
	digitalWrite(MotorRight2, MotorRight2Status);
}

void SendStatus(){

	String out = "";
	out += MotorLeft1Status;
	out += ",";
	out += MotorLeft2Status;
	out += ",";
	out += MotorRight1Status;
	out += ",";
	out += MotorRight2Status;
	out += ",";
	out += leftspeed;
	out += ",";
	out += rightspeed;
	out += ",";
	out += servoXPoint;
	out += ",";
	out += servoYPoint;
	SendMessage(out);
}
void SendMessage(String data){
	Serial.println(data);
}

